/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.skinsrestorer.api.SkinVariant;
import net.skinsrestorer.api.interfaces.ISRPlayer;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.reflection.exception.ReflectionException;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.bukkit.utils.WrapperBukkit;
import net.skinsrestorer.shadow.aikar.commands.BaseCommand;
import net.skinsrestorer.shadow.aikar.commands.CommandHelp;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandAlias;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandCompletion;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandPermission;
import net.skinsrestorer.shadow.aikar.commands.annotation.Description;
import net.skinsrestorer.shadow.aikar.commands.annotation.HelpCommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Optional;
import net.skinsrestorer.shadow.aikar.commands.annotation.Single;
import net.skinsrestorer.shadow.aikar.commands.annotation.Subcommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Syntax;
import net.skinsrestorer.shadow.aikar.commands.bukkit.contexts.OnlinePlayer;
import net.skinsrestorer.shared.commands.ISRCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="sr|skinsrestorer")
@CommandPermission(value="%sr")
public class SrCommand
extends BaseCommand
implements ISRCommand {
    private final SkinsRestorer plugin;

    @HelpCommand
    @Syntax(value="%helpHelpCommand")
    public void onHelp(CommandSender sender, CommandHelp help) {
        this.onHelp(WrapperBukkit.wrapCommandSender(sender), help);
    }

    @Subcommand(value="reload")
    @CommandPermission(value="%srReload")
    @Description(value="%helpSrReload")
    public void onReload(CommandSender sender) {
        this.onReload(WrapperBukkit.wrapCommandSender(sender));
    }

    @Subcommand(value="status")
    @CommandPermission(value="%srStatus")
    @Description(value="%helpSrStatus")
    public void onStatus(CommandSender sender) {
        this.onStatus(WrapperBukkit.wrapCommandSender(sender));
    }

    @Subcommand(value="drop|remove")
    @CommandPermission(value="%srDrop")
    @CommandCompletion(value="PLAYER|SKIN @players @players @players")
    @Description(value="%helpSrDrop")
    @Syntax(value=" <player|skin> <target> [target2]")
    public void onDrop(CommandSender sender, ISRCommand.PlayerOrSkin playerOrSkin, String targets) {
        this.onDrop(WrapperBukkit.wrapCommandSender(sender), playerOrSkin, targets);
    }

    @Subcommand(value="props")
    @CommandPermission(value="%srProps")
    @CommandCompletion(value="@players")
    @Description(value="%helpSrProps")
    @Syntax(value=" <target>")
    public void onProps(CommandSender sender, @Single OnlinePlayer target) {
        this.onProps(WrapperBukkit.wrapCommandSender(sender), WrapperBukkit.wrapPlayer(target.getPlayer()));
    }

    @Subcommand(value="applyskin")
    @CommandPermission(value="%srApplySkin")
    @CommandCompletion(value="@players")
    @Description(value="%helpSrApplySkin")
    @Syntax(value=" <target>")
    public void onApplySkin(CommandSender sender, @Single OnlinePlayer target) {
        this.onApplySkin(WrapperBukkit.wrapCommandSender(sender), WrapperBukkit.wrapPlayer(target.getPlayer()));
    }

    @Subcommand(value="createcustom")
    @CommandPermission(value="%srCreateCustom")
    @CommandCompletion(value="@skinName @skinUrl")
    @Description(value="%helpSrCreateCustom")
    @Syntax(value=" <skinName> <skinUrl> [classic/slim]")
    public void onCreateCustom(CommandSender sender, String name, String skinUrl, @Optional SkinVariant skinVariant) {
        this.onCreateCustom(WrapperBukkit.wrapCommandSender(sender), name, skinUrl, skinVariant);
    }

    @Subcommand(value="setskinall")
    @CommandCompletion(value="@Skin")
    @Description(value="Set the skin to evey player")
    @Syntax(value=" <Skin / Url> [classic/slim]")
    public void onSetSkinAll(CommandSender sender, String skinUrl, @Optional SkinVariant skinVariant) {
        this.onSetSkinAll(WrapperBukkit.wrapCommandSender(sender), skinUrl, skinVariant);
    }

    @Subcommand(value="purgeolddata")
    @Description(value="Purge old skin data from over x days ago")
    @Syntax(value=" <targetdaysold>")
    public void onPurgeOldData(CommandSender sender, int days) {
        this.onPurgeOldData(WrapperBukkit.wrapCommandSender(sender), days);
    }

    @Override
    public void reloadCustomHook() {
        this.plugin.getSkinApplierBukkit().setOptFileChecked(false);
    }

    @Override
    public String getPlatformVersion() {
        return this.plugin.getServer().getVersion();
    }

    @Override
    public String getProxyMode() {
        return String.valueOf(this.plugin.isProxyMode());
    }

    @Override
    public List<IProperty> getPropertiesOfPlayer(ISRPlayer player) {
        try {
            Map<String, Collection<IProperty>> propertyMap = this.plugin.getSkinApplierBukkit().getPlayerProperties(player.getWrapper().get(Player.class));
            return new ArrayList<IProperty>(propertyMap.get("textures"));
        }
        catch (ReflectionException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public SrCommand(SkinsRestorer plugin) {
        this.plugin = plugin;
    }

    @Override
    public SkinsRestorer getPlugin() {
        return this.plugin;
    }
}

